/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 2.4.4                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2009,2010 COLLARD Christophe
 * copyright © 2009,2010 Centre National de la Recherche Scientifique
 * copyright © 2009,2010 Arts et Métiers ParisTech
 * copyright © 2009,2010 Laboratoire de Physique et Mécanique des Matériaux
 ***************************************************************/

/*
    send receive-test belongs to Message Passing Interface for Simula+ Object Libraries (MPISOL++)
    MPISOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type send-test.
#endif

#if !defined(__SEND_TEST_H)
#define _send_test_h


#if !defined (__MPI_H)
#include <mpi.h>
#endif

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "MOL++/matrix.h"
#endif

#if !defined(__SYMMATRIX_H)
#include "MOL++/symmatrix.h"
#endif

#if !defined(__TENSOR2_H)
#include "MOL++/tensors2.h"
#endif

#if !defined(__SYMTENSOR2_H)
#include "MOL++/symtensors2.h"
#endif

#if !defined(__TENSOR3_H)
#include "MOL++/tensors3.h"
#endif

#if !defined(__TENSOR4_H)
#include "MOL++/tensors4.h"
#endif

#if !defined(__SYMTENSOR4_H)
#include "MOL++/symtensors4.h"
#endif

#if !defined(__POLYNOMS_H)
#include "MOL++/polynoms.h"
#endif

#if !defined(__SEND_H)
#include "MPISOL++/send.h"
#endif

#if !defined(__RECEIVE_H)
#include "MPISOL++/receive.h"
#endif

#if !defined(__AFFICHE_H)
#include "tests/affiche.h"
#endif

using namespace std;
using namespace mol;
using namespace mpisol;


//================================
int test_send_receive (int detail)
//================================
{
  int result=1;
  int myrank = MPI::COMM_WORLD.Get_rank();
  int nb_threads = MPI::COMM_WORLD.Get_size();

  int test = true;


  //-----scalar-----------------------------------------------------------------------------------------------------------------------------

  long double scalar = 0, value = 125.134745;

  if (myrank == nb_threads-1)
    { scalar = value;
      send (scalar, 0, 1);
    }

  if (!myrank)
    { receive (scalar, nb_threads-1, 1);
      if (detail) affiche ("send receive scalar", scalar==value);
      else result *= (scalar==value);
    }


  //-----vector-----------------------------------------------------------------------------------------------------------------------------

  vector<long double> u(9), u_mpi;
  u[1]=2.; u[2]=7.25; u[3]=14.67; u[4]=234.2; u[5]=0.; u[6]=0.543378; u[7]=13.; u[8]=0.; u[9]=45.;

  if (myrank == nb_threads-1)
    { u_mpi = u;
      send (u_mpi, 0, 10);
      //      system ("hostname");
    }

  if (!myrank)
    { receive (u_mpi, nb_threads-1, 10);
      //      system ("hostname");
      //      cout << "Hi, I'm thread number " << nb_threads << " and I received vector: " << u_mpi;
      if (detail) affiche ("send receive vector", u==u_mpi);
      else result *= (u==u_mpi);
    }


  //-----matrix-----------------------------------------------------------------------------------------------------------------------------

  u_mpi = u;
  matrix<long double> mat(5,9), mat_mpi;
  mat(1,1)=2; mat(1,2)=-1; mat(1,4)=.5; mat(1,7)=-.25; mat(1,9)=-2;
  mat(2,2)=1; mat(2,4)=-9;mat(2,6)=2.65; mat(2,7)=5.4; mat(2,8)=3;
  mat[3] = u;
  mat[4] =& u;
  mat(5,1)=2; mat(5,2)=7; mat(5,3)=-1; mat(5,4)=-5; mat(5,5)=-.321; mat(5,6)=1; mat(5,7)=-1; mat(5,6)=-1; mat(5,7)=2;

  if (myrank == nb_threads-1)
    { mat_mpi = mat;
      send (mat_mpi, 0, 20);
      //      system ("hostname");
    }

  if (!myrank)
    { receive (mat_mpi, nb_threads-1, 20);
      //      cout << mat_mpi;
      //      system ("hostname");
      if (detail) affiche ("send receive matrix", mat==mat_mpi);
      else result *= (mat==mat_mpi);
    }


  //-----symmatrix--------------------------------------------------------------------------------------------------------------------------

  u = u_mpi;
  symmatrix<long double> smat(9,9), smat_mpi;
  for(int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      smat(i,j) = 5*j - i;
  smat[9] =& u;


  if (myrank == nb_threads-1)
    { smat_mpi = smat;
      send (smat_mpi, 0, 30);
    }

  if (!myrank)
    { receive (smat_mpi, nb_threads-1, 30);
      if (detail) affiche ("send receive symmatrix", smat==smat_mpi);
      else result *= (smat==smat_mpi);
    }


  //-----tensor2----------------------------------------------------------------------------------------------------------------------------

  tensor2<long double> tsr2(5,9), tsr2_mpi;
  tsr2(1,1)=2; tsr2(1,2)=-1; tsr2(1,4)=.5; tsr2(1,7)=-.25; tsr2(1,9)=-2;
  tsr2(2,2)=1; tsr2(2,4)=-9;tsr2(2,6)=2.65; tsr2(2,7)=5.4; tsr2(2,8)=3;
  u = u_mpi;
  tsr2[3] = u;
  tsr2[4] =& u;
  tsr2(5,1)=2; tsr2(5,2)=7; tsr2(5,3)=-1; tsr2(5,4)=-5; tsr2(5,5)=-.321; tsr2(5,6)=1; tsr2(5,7)=-1; tsr2(5,6)=-1; tsr2(5,7)=2;

  if (myrank == nb_threads-1)
    { tsr2_mpi = tsr2;
      send (tsr2_mpi, 0, 40);
    }

  if (!myrank)
    { receive (tsr2_mpi, nb_threads-1, 40);
      if (detail) affiche ("send receive tensor2", tsr2==tsr2_mpi);
      else result *= (tsr2==tsr2_mpi);
    }


  //-----symtensor2-------------------------------------------------------------------------------------------------------------------------

  u = u_mpi;
  symtensor2<long double> stsr(9,9), stsr_mpi;
  for(int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      stsr(i,j) = 5*j - i;
  stsr[9] =& u;

  if (myrank == nb_threads-1)
    { stsr_mpi = stsr;
      send (stsr_mpi, 0, 50);
    }

  if (!myrank)
    { receive (stsr_mpi, nb_threads-1, 50);
      if (detail) affiche ("send receive symtensor2", stsr==stsr_mpi);
      else result *= (stsr==stsr_mpi);
    }

  //-----tensor3----------------------------------------------------------------------------------------------------------------------------

  tensor3<long double> tsr3(2,5,9), tsr3_mpi;
  for (int i=1; i<=2; i++)
    for(int j=1; j<=5; j++)
      for (int k=1; k<=9; k++)
	tsr3(i,j,k) = 2*i - j + 3*k;

  tsr3[2] =& mat;

  if (myrank == nb_threads-1)
    { tsr3_mpi = tsr3;
      send (tsr3_mpi, 0, 60);
    }

  if (!myrank)
    { receive (tsr3_mpi, nb_threads-1, 60);
      if (detail) affiche ("send receive tensor3", tsr3==tsr3_mpi);
      else result *= (tsr3==tsr3_mpi);
    }


  //-----tensor4----------------------------------------------------------------------------------------------------------------------------

  tensor4<long double> tsr4(7,2,5,9), tsr4_mpi;
  for (int i=1; i<=7; i++)
    for(int j=1; j<=2; j++)
      for (int k=1; k<=5; k++)
	for (int l=1; l<=9; l++)
	  tsr4(i,j,k,l) = 2*i - j + 3*k*(l-13);

  tsr4[2] =& tsr3;

  if (myrank == nb_threads-1)
    { tsr4_mpi = tsr4;
      send (tsr4_mpi, 0, 70);
    }

  if (!myrank)
    { receive (tsr4_mpi, nb_threads-1, 70);
      if (detail) affiche ("send receive tensor4", tsr4==tsr4_mpi);
      else result *= (tsr4==tsr4_mpi);
    }


  //-----symtensor4-------------------------------------------------------------------------------------------------------------------------

  u = u_mpi;
  symtensor4<long double> stsr4(9,9,7,7), stsr4_mpi;
  for(int i=1; i<=9; i++)
    for (int j=1; j<=9; j++)
      for (int k=1; k<=7; k++)
	for (int l=1; l<=7; l++)
	  stsr4(i,j,k,l) = 5*(i + j) / (k * l);

  if (myrank == nb_threads-1)
    { stsr4_mpi = stsr4;
      send (stsr4_mpi, 0, 80);
    }

  if (!myrank)
    { receive (stsr4_mpi, nb_threads-1, 80);
      if (detail) affiche ("send receive symtensor4", stsr4==stsr4_mpi);
      else result *= (stsr4==stsr4_mpi);
    }

  //-----polynom----------------------------------------------------------------------------------------------------------------------------

  polynom<long double> Px(9), Px_mpi;
  Px[0]=2.; Px[2]=7.25; Px[3]=14.67; Px[4]=234.2; Px[5]=0.; Px[6]=0.543378; Px[7]=13.; Px[8]=0.; Px[9]=45.;

  if (myrank == nb_threads-1)
    { Px_mpi = Px;
      send (Px_mpi, 0, 90);
    }

  if (!myrank)
    { receive (Px_mpi, nb_threads-1, 90);
      if (detail) affiche ("send receive polynom", Px==Px_mpi);
      else result *= (Px==Px_mpi);
    }


  //----------------------------------------------------------------------------------------------------------------------------------------

  MPI::COMM_WORLD.Barrier();

  if (!myrank)
    { cout << endl;
      cout << "============================================================== \n";
      if (result) cout << green << "                  send revceive test passed" << reset;
      else cout << red << "                  send receive test failed" << reset;
      cout << "============================================================== \n";
    }

  return result;
}


#endif
